@program mpi-time-phase.muf
i
( mpi-time-phase.muf )

( 20 November 1999, L. Erickson <wwonko@rdwarf.com> )

( This program is copyright 1999, Louis Erickson.  It may be used freely )
( presuming this message and all credits to the authors are left intact. )

( This program is used to read some props from the current room, or, )
( it's parent rooms, reads the format, offsets, etc, and finally )
( spits a useful string. )

( Depending on the time of day, including an offset, it will return )
( night morning daytime or dusk )

( setting props time/localoffs and time/localfmt will affect the )
( time-zone from an environment room, downwards.  localoffs is the )
( number of hours from GMT to offset the room's time-zone. )
( localfmt is how the time for a room is displayed.  See strfmttime )
( This is one my earliest MUF bits, and is a little sloppy. )
 
$include $lib/props
$include $lib/strings
        
: getgmtsecs ( -- i )
        ( This function reads the system time, and hands it back, )
        ( converted to GMT )
        systime
        gmtoffset +
        ( If that's adjusted to the local MUCK time, then correct here. )
;       
 
        
: getroomoffset ( d -- i )   
        ( This reads the hourly offset from GMT for object d )
        ( and converts it to the seconds from GMT that the MUF )
        ( functions like )
        "time/localoffs" envprop        ( get the offset )
        dup                             ( make a copy )
        "" strcmp not                   ( check for a blank )
        if pop 0 then                   ( if it is, use 0 )
        atoi
        3600 *
;
        
: getroomfmt ( d -- s )
        ( This reads the format string for a particular room, )
        ( supplying a default if none is set )
        "time/localfmt" envprop
;
        
        
var myroom
: buildroomtime ( d -- s )
        ( This prepares a string for a display for a particular room )
        myroom !
        myroom @
        getroomfmt
        dup
        "" strcmp
        if 
                getgmtsecs   
                myroom @ 
                getroomoffset
                +
                timefmt
        then
;
        
: showroomtime ( d d -- )
( this shows the user, the first param, the time in the room )
( the second item. )
        buildroomtime
        dup "" strcmp
        if
                notify
        else
                pop pop
        then
;
        
: showglobaltime ( d -- )
( this shows the user, the first param, the system time )
        "muckname" sysparm
         " time: %l:%M:%S %p %Z %d%b%y"
        systime
        timefmt
        strcat
        notify 
;
var myhour
: translatenumtophase ( i -- s )
        ( takes an hour and makes it into a named string )
        ( This is where the data for the translation is )
        myhour !
        "night"
        myhour @ 5 >= myhour @ 10 <= and
        if pop "morning" then
        myhour @ 11 >= myhour @ 16 <= and
        if pop "daytime" then
        myhour @ 17 >= myhour @ 20 <= and
        if pop "dusk" then
;
        
       
: getroomphase ( d -- s )
        ( Takes a dbref for the room and spits the name of the phase )
        getgmtsecs   
        swap
        getroomoffset
        +
        "%H" swap timefmt
        atoi
        translatenumtophase
;
: testit ( -- )
        ( call translatenumtophase for all the phases )
        0
        begin
                dup
                translatenumtophase
                me @
                swap
                notify
                1 +
                dup
                23 >
        until
;
: showcurrentroomphase ( -- )
        loc @
        getroomphase
;
.
c
q
@set mpi-time-phase.muf=L
@set mpi-time-phase.muf=3
@register mpi-time-phase.muf
"Don't forget: @set #0=_msgmacs/time-phase:{muf:#xxxx,``}

